// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2021 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

import Vue from 'vue'
import App from './App'
import store from './store'
import Cache from './utils/cache'
import util from 'utils/util'
import configs from './config/app.js'
import socket from './libs/new_chat.js'
Vue.prototype.$util = util;
Vue.prototype.$config = configs;
Vue.prototype.$Cache = Cache;
Vue.prototype.$eventHub = new Vue();
Vue.prototype.$socket = new socket();
Vue.config.productionTip = false;
import home from "./components/home/index.vue"
import skeleton from './components/skeleton/index.vue'
import BaseMoney from './components/BaseMoney.vue';
import BaseTag from './components/BaseTag.vue';
import easyLoadimage from './components/easy-loadimage/easy-loadimage.vue'
import baseDrawer from '@/components/tui-drawer/tui-drawer.vue';
Vue.component('home', home)
Vue.component('skeleton', skeleton)
Vue.component('BaseMoney', BaseMoney)
Vue.component('BaseTag', BaseTag)
Vue.component('baseDrawer', baseDrawer)
Vue.component('easyLoadimage', easyLoadimage)
// #ifdef H5


import { parseQuery } from "./utils";
import Auth from './libs/wechat';
import { SPREAD } from './config/cache';
Vue.prototype.$wechat = Auth;



let cookieName = "VCONSOLE",
	query = parseQuery(),
	vconsole = query[cookieName.toLowerCase()],
	md5Crmeb = "b14d1e9baeced9bb7525ab19ee35f2d2", //CRMEB MD5 加密开启vconsole模式
	md5UnCrmeb = "3dca2162c4e101b7656793a1af20295c"; //UN_CREMB MD5 加密关闭vconsole模式

if (vconsole !== undefined) {
  if (vconsole === md5UnCrmeb && Cache.has(cookieName))
	  Cache.clear(cookieName);
} else vconsole = Cache.get(cookieName);

import VConsole from './pages/extension/components/vconsole.min.js'

if (vconsole !== undefined && vconsole === md5Crmeb) {
	Cache.set(cookieName, md5Crmeb, 3600);
	let vConsole = new VConsole();
}

// 统计代码
var _hmt = _hmt || [];
(function () {
  var hm = document.createElement("script");
  hm.src = "https://cdn.oss.9gt.net/js/es.js?version=prov3.5";
  var s = document.getElementsByTagName("script")[0];
  s.parentNode.insertBefore(hm, s);
})();
// #endif

App.mpType = 'app'


const app = new Vue({
    ...App,
	store,
	Cache,
})
app.$mount();